<?php

namespace Suiterus\Adg\Models\SPMS;

use Suiterus\Adg\Models\SPMS\Mfo;
use Illuminate\Database\Eloquent\Model;

class PerformanceEvaluation extends Model
{

    protected $fillable = [
        'evaluation_id',
        'mfo',
        'rate_q_ave',
        'rate_e_ave',
        'rate_t_ave',
        'average',
        'overall_rate',
        'percentage'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.performance_evaluation';
        parent::__construct($attributes);
    }

    public function mfoInfo(){
        return $this->belongsTo(Mfo::class, 'mfo', 'id');
    }

    public function employeeEvaluation()
    {
        return $this->belongsTo(EmployeeEvaluation::class, 'evaluation_id', 'id');
    }

    public function metricEvaluations()
    {
        return $this->hasMany(MetricEvaluation::class, 'performance_eval_id', 'id');
    }
}
