<?php

namespace Suiterus\Adg\Models\SPMS;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PCRFormPermission extends Model
{
    use HasFactory;

    protected $fillable = [
        'pcr_form_type_id',
        'name',
        'minimum_salary_grade',
        'maximum_salary_grade',
        'permission_type'
    ];

    protected $appends = [
        'permission_type_name'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.pcr_form_permissions';
        parent::__construct($attributes);
    }

    public function pcrFormType()
    {
        return $this->belongsTo(PCRFormType::class, 'pcr_form_type_id', 'id');
    }

    public function getPermissionTypeNameAttribute(){
        if($this->permission_type == 1){
            return 'create';
        }
        if($this->permission_type == 2){
            return 'view';
        }
    }
}
