<?php

namespace Suiterus\Adg\Models\SPMS;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\SPMS\MetricEvaluation;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class MetricEvaluationHistory extends Model
{
    use HasFactory;

    protected $fillable = [
        'metric_evaluation_id',
        'user_id',
        'old',
        'new',
    ];

    protected $casts = [
        'old' => 'json',
        'new' => 'json',
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.metric_evaluation_histories';
        parent::__construct($attributes);
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id')->without([
            'currentRole',
            'roles',
            'permissions',
            'storage',
            'employeeMetaInfo',
            'supervisor',
            'user_supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        ]);
    }

    public function metricEvaluation()
    {
        return $this->belongsTo(MetricEvaluation::class, 'metric_evaluation_id', 'id');
    }
}
