<?php

namespace Suiterus\Adg\Models\SPMS;

use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\SPMS\MetricEvaluationHistory;

class MetricEvaluation extends Model
{
    protected $fillable = [
        'performance_eval_id',
        'eval_classification_id',
        'description',
        'success_q',
        'success_e',
        'success_t',
        'actual_q',
        'actual_e',
        'actual_t',
        'rate_q',
        'rate_e',
        'rate_t',
        'remarks_q',
        'remarks_e',
        'remarks_t',
        'average',
        'remarks',
        'status',
        'revision_remarks'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.metric_evaluation';
        parent::__construct($attributes);
    }

    public function performanceEvaluation()
    {
        return $this->belongsTo(PerformanceEvaluation::class, 'performance_eval_id', 'id');
    }

    public function evaluationClassification()
    {
        return $this->belongsTo(EvaluationClassification::class, 'eval_classification_id', 'id');
    }

    public function histories(){
        return $this->hasMany(MetricEvaluationHistory::class, 'metric_evaluation_id', 'id');
    }
}
