<?php

namespace Suiterus\Adg\Models\SPMS;

use App\Models\User;
use Suiterus\Adg\Models\SM\Unit;
use Suiterus\Adg\Models\SM\Office;
use Suiterus\Adg\Traits\Auditable;
use Suiterus\Adg\Models\SM\Section;
use Suiterus\Adg\Models\SM\Division;
use Suiterus\Adg\Models\SM\Department;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\Activity\Audit;

class EmployeeEvaluation extends Model
{

    use Auditable;

    protected $historyModel = Audit::class;

    protected $fillable = [
        'employee_id',
        'employee_ip_address',
        'evaluator',
        'evaluator_ip_address',
        'approver',
        'office_id',
        'department_id',
        'division_id',
        'section_id',
        'unit_id',
        'approver_ip_address',
        'start_date',
        'end_date',
        'q_average',
        'e_average',
        't_average',
        'overall_rate',
        'review_form_type',
        'status',
        'submitted_date',
        'review_date',
        'approved_date',
        'comment_recommendation',
        'reason'
    ];

    protected $with = [
        'pcrFormType',
        'createdAudit',
    ];

    protected $auditRelations = [
        'pcrFormType',
        'employee',
        'evaluator',
        'approver',
        'office.headEmployee.employeeMetaInfo',
        'department.headEmployee.employeeMetaInfo',
        'division.headEmployee.employeeMetaInfo',
        'section.headEmployee.employeeMetaInfo',
        'unit.headEmployee.employeeMetaInfo',
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.employee_evaluation';
        parent::__construct($attributes);
    }

    public function performanceEvaluations()
    {
        return $this->hasMany(PerformanceEvaluation::class, 'evaluation_id', 'id');
    }

    public function pcrFormType()
    {
        return $this->belongsTo(PCRFormType::class, 'review_form_type', 'id');
    }

    public function employee()
    {
        return $this->belongsTo(User::class, 'employee_id', 'id');
    }

    public function evaluator()
    {
        return $this->belongsTo(User::class, 'evaluator', 'id');
    }

    public function approver()
    {
        return $this->belongsTo(User::class, 'approver', 'id');
    }

    public function createdAudit()
    {
        return $this->morphOne(Audit::class, 'auditable');
    }


    public function office()
    {
        return $this->belongsTo(Office::class, 'office_id', 'id')->without([
            'childOffices',
            'department',
            'headEmployee'
        ]);
    }

    public function department()
    {
        return $this->belongsTo(Department::class, 'department_id', 'id')->without([
            'divisions'
        ]);
    }

    public function division()
    {
        return $this->belongsTo(Division::class, 'division_id', 'id')->without([
            'sections'
        ]);
    }

    public function section()
    {
        return $this->belongsTo(Section::class, 'section_id', 'id')->without([
            'units'
        ]);
    }

    public function unit()
    {
        return $this->belongsTo(Unit::class, 'unit_id', 'id');
    }
}
