<?php

namespace Suiterus\Adg\Models\SPMS;

use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\SPMS\MetricEvaluation;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class BalanceScoreCard extends Model
{
    use HasFactory;

    protected $fillable = [
        'first_half_metric_evaluation_id',
        'second_half_metric_evaluation_id',
        'objectives',
        'plans',
        'success_indicator',
        'q1_action_plan',
        'q1_status',
        'q1_legend',
        'q2_action_plan',
        'q2_status',
        'q2_legend',
        'first_half_legend',
        'q3_action_plan',
        'q3_status',
        'q3_legend',
        'q4_action_plan',
        'q4_status',
        'q4_legend',
        'annual_legend',
        'created_by',
        'updated_by',
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.balance_score_cards';
        parent::__construct($attributes);
    }

    public function firstHalfMetricEvaluation(){
        return $this->belongsTo(MetricEvaluation::class, 'first_half_metric_evaluation_id');
    }

    public function secondHalfMetricEvaluation(){
        return $this->belongsTo(MetricEvaluation::class, 'second_half_metric_evaluation_id');
    }
}
