<?php

namespace Suiterus\Adg\Models\SM;

use App\Models\User;
use Suiterus\Adg\Models\SM\Office;
use Suiterus\Adg\Models\SM\Section;
use Suiterus\Adg\Models\SM\Department;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\SPMS\EmployeeEvaluation;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Suiterus\Adg\Models\OrgStructure\OrganizationStructurePcr;
use Suiterus\Adg\Models\OrgStructure\OrganizationStructureOvertime;

class Unit extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name',
        'description',
        'office_id',
        'department_id',
        'division_id',
        'section_id',
        'head_employee_id',
        'status',
        'created_by',
        'updated_by',
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.units';
        parent::__construct($attributes);
    }

    public function headEmployee()
    {
        return $this->belongsTo(User::class, 'head_employee_id', 'id')->without(
            'currentRole',
            'roles',
            'permissions',
            'storage',
            'employeeMetaInfo',
            'supervisor',
            'user_supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        );
    }

    public function pcrs()
    {
        return $this->morphMany(OrganizationStructurePcr::class, 'pcrable');
    }

    public function overtime()
    {
        return $this->morphMany(OrganizationStructureOvertime::class, 'otable');
    }

    public function office()
    {
        return $this->belongsTo(Office::class, 'office_id', 'id');
    }

    public function department()
    {
        return $this->belongsTo(Department::class, 'department_id', 'id');
    }

    public function division()
    {
        return $this->belongsTo(Division::class, 'division_id', 'id');
    }

    public function section()
    {
        return $this->belongsTo(Section::class, 'section_id', 'id');
    }

    public function evaluation()
    {
        return $this->hasMany(EmployeeEvaluation::class, 'unit_id', 'id');
    }

    public function getOrganizationTypeAttribute()
    {
        return 'unit';
    }
}
