<?php

namespace Suiterus\Adg\Models\SM;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\SM\Branch;


class Suspension extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'suspensions';

    protected $fillable = [
        'title',
        'description',
        'branch_id',
        'time_effectivity',
        'date',
        'status',
        'created_by',
        'updated_by'
    ];

    public function branch(){
        return $this->hasOne(Branch::class, 'branch_id', 'id');
    }
}
