<?php

namespace Suiterus\Adg\Models\SM;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\Timekeeping\Roster\RosterDayEmployeeShift;
use Suiterus\Adg\Models\Timekeeping\Roster\RosterHeadEmployeeShift;
use Suiterus\Adg\Models\Timekeeping\Roster\RosterStaffPerDay;

class Shift extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'shifts';

    protected $fillable = [
        'code',
        'name',
        'description',
        'shift_in',
        'shift_out',
        'break_in',
        'break_out',
        'work_hours',
        'status'
    ];

    protected $appends = [
        'formatted_shift_in',
        'formatted_shift_out',
        'formatted_break_in',
        'formatted_break_out'
    ];
    public function minStaffPerDay() {
        return $this->hasMany(RosterStaffPerDay::class,'shift_id', 'id');
    }
    
    public function employeeShift() {
        return $this->hasMany(RosterDayEmployeeShift::class, 'shift_id', 'id');
    }

    public function headEmployeeShift() {
        return $this->hasMany(RosterHeadEmployeeShift::class, 'shift_id', 'id');
    }
    public function getFormattedShiftInAttribute() {
        $formatted = date("g:i A", strtotime($this->shift_in));
        return $formatted;
    }
    
    public function getFormattedShiftOutAttribute() {
        $formatted = date("g:i A", strtotime($this->shift_out));
        return $formatted;
    }

    public function getFormattedBreakInAttribute() {
        $formatted = date("g:i", strtotime($this->break_in));
        return $formatted;
    }

    public function getFormattedBreakOutAttribute() {
        $formatted = date("g:i", strtotime($this->break_out));
        return $formatted;
    }
    
}
