<?php

namespace Suiterus\Adg\Models\SM;

use App\Models\User;
use Suiterus\Adg\Models\SM\Unit;
use Suiterus\Adg\Models\SM\Division;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\SPMS\EmployeeEvaluation;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Suiterus\Adg\Models\OrgStructure\OrganizationStructurePcr;
use Suiterus\Adg\Models\OrgStructure\OrganizationStructureOvertime;

class Section extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name',
        'description',
        'division_id',
        'head_employee_id',
        'status',
        'created_by',
        'updated_by'
    ];

    protected $with = [
        'units'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.sections';
        parent::__construct($attributes);
    }

    public function headEmployee()
    {
        return $this->belongsTo(User::class, 'head_employee_id', 'id')->without(
            'currentRole',
            'roles',
            'permissions',
            'storage',
            'employeeMetaInfo',
            'supervisor',
            'user_supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        );
    }

    public function pcrs()
    {
        return $this->morphMany(OrganizationStructurePcr::class, 'pcrable');
    }

    public function overtime()
    {
        return $this->morphMany(OrganizationStructureOvertime::class, 'otable');
    }

    public function division()
    {
        return $this->belongsTo(Division::class, 'division_id', 'id');
    }

    public function units()
    {
        return $this->hasMany(Unit::class, 'section_id', 'id');
    }

    public function evaluation()
    {
        return $this->hasMany(EmployeeEvaluation::class, 'section_id', 'id');
    }

    public function getOrganizationTypeAttribute()
    {
        return 'section';
    }
}
