<?php

namespace Suiterus\Adg\Models\SM;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ScheduleTitle extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'schedule_titles';

    protected $fillable = [
        'type',
        'title',
        'shift_code',
        'description',
        'basis',
        'hasSchedule',
        'status',
        'created_by',
        'updated_by',
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE').'.schedule_titles';
        parent::__construct($attributes);
    }

    public function schedule_type() {
        return $this->belongsTo('Suiterus\Adg\Models\SM\ScheduleType', 'type', 'id');
    }

    // public function schedule_template() {
    //     return $this->hasMany('Suiterus\Adg\Models\SM\ScheduleTemplate', 'title_id', 'id');
    // }

    public function schedule_template() {
        return $this->morphMany(ScheduleTemplate::class, 'schedulable');
    }

}
