<?php

namespace Suiterus\Adg\Models\SM;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\Timekeeping\ScheduleTemplateTimetable;
use Suiterus\Adg\Models\Timekeeping\TemporarySchedule;
use Suiterus\Adg\Models\Timekeeping\Timetable;

class ScheduleTemplate extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $fillable = [
        'day',
        'status',
        'created_by',
        'updated_by',
    ];

    protected $with = [
        'timetables'
    ];

    protected $appends = [
        'standard_time_start',
        'standard_time_end',
        'standard_max_time',
    ];

    // public function schedule_title() {
    //     return $this->belongsTo('Suiterus\Adg\Models\SM\ScheduleTitle', 'title_id', 'id');
    // }

    public function schedule_title() {
        return $this->belongsTo(ScheduleTitle::class, 'schedulable_id', 'id')->where('schedulable_type', ScheduleTitle::class);
    }

    public function temporary_schedule() {
        return $this->belongsTo(TemporarySchedule::class, 'schedulable_id', 'id')->where('schedulable_type', TemporarySchedule::class);
    }

    public function schedulable() {
        return $this->morphTo();
    }

    public function timetables() {
        return $this->belongsToMany(Timetable::class);
    }

    public function timetable_records() {
        return $this->hasMany(ScheduleTemplateTimetable::class, 'schedule_template_id', 'id');
    }

    public function getStandardTimeStartAttribute() {
        $formatted = date("g:i A", strtotime($this->time_start));
        return $formatted;
    }
    public function getStandardTimeEndAttribute() {
        $formatted = date("g:i A", strtotime($this->time_end));
        return $formatted;
    }
    public function getStandardMaxTimeAttribute() {
        $formatted = date("g:i A", strtotime($this->max_time));
        return $formatted;
    }

}
