<?php

namespace Suiterus\Adg\Models\SM;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SalaryStandardization extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'salary_standardizations';

    protected $fillable = [
        'title',
        'effective_year',
        'status',
        'active_tranche',
        'employee_type_id',
        'premium_payment',
        'created_by',
        'updated_by'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.salary_standardizations';
        parent::__construct($attributes);
    }

    public function salary_grades() {
        return $this->hasMany('Suiterus\Adg\Models\SM\SalaryGrade', 'ss_id', 'id');
    }

    public function employeeType() {
        return $this->belongsTo(EmployeeType::class, 'employee_type_id', 'id');
    }
}
