<?php

namespace Suiterus\Adg\Models\SM;

use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\Salary\PublicSalary;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\Salary\PrivateSalary;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class SalaryGrade extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $fillable = [
        'ss_id',
        'salary_grade',
        'step',
        'value',
        'status',
        'created_by',
        'updated_by',
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE').'.salary_grades';
        parent::__construct($attributes);
    }

    public function getValueAttribute($value) {
        return number_format($value);
    }

    public function salary_standardization() {
        return $this->belongsTo('Suiterus\Adg\Models\SM\SalaryStandardization', 'ss_id', 'id');
    }

    public function publicSalary(){
        return $this->hasOne(PublicSalary::class);
    }

    public function privateSalary(){
        return $this->hasOne(PrivateSalary::class, 'salary_grade', 'id');
    }

}
