<?php

namespace Suiterus\Adg\Models\SM;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\Timekeeping\Roster\RosterEmployeeGroup;
use Suiterus\Hrjp\Models\Position;

class RosterGroup extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'roster_groups';

    protected $fillable = [
        'name',
        'description',
        'status'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.roster_groups';
        $this->connection = env('ADG_DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function position(){
        return $this->hasMany(Position::class, 'group_id', 'id');
    }

    public function rosterEmployeeGroups(){
        return $this->hasMany(RosterEmployeeGroup::class, 'group_id', 'id');
    }

}
