<?php

namespace Suiterus\Adg\Models\SM;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\ServiceRecord\ServiceRecord;

class Remark extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $fillable = [
        'abbreviation',
        'meaning',
        'status'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.remarks';
        parent::__construct($attributes);
    }

    public function serviceRecord(){
        $this->belongsTo(ServiceRecord::class, 'remark_id', 'id');
    }
    
}
