<?php

namespace Suiterus\Adg\Models\SM;


use App\Models\User;

use Suiterus\Adg\Models\SM\Office;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class OfficePerEmployee extends Model
{
    use HasFactory;

    protected $connection = 'adg_db';
    protected $table = 'office_per_employees';

    protected $fillable = [
        'office_id',
        'user_id',
        'created_by'
    ];

    protected $with = [
        'user'
    ];
    

    public function office()
    {
        return $this->belongsTo(Office::class, 'office_id', 'id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id')->without([
            'employeeMetaInfo',
            'roles',
            'permissions',
            'storage',
            'supervisor',
            'user_supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        ]);
    }
}
