<?php

namespace Suiterus\Adg\Models\SM;

use App\Models\User;

use Suiterus\Adg\Models\SM\Office;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class OfficeHierarchy extends Model
{
    use HasFactory;

    protected $fillable = [
        'parent_office_id',
        'child_office_id',
        'created_by',
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.office_hierarchy';
        parent::__construct($attributes);
    }

    public function parentOffice()
    {
        return $this->belongsTo(Office::class, 'parent_office_id', 'id');
    }

    public function childOffice()
    {
        return $this->belongsTo(Office::class, 'child_office_id', 'id');
    }
}
