<?php

namespace Suiterus\Adg\Models\SM;


use App\Models\User;
use Suiterus\Adg\Models\SM\Unit;
use Suiterus\Adg\Models\SM\Division;
use Suiterus\Adg\Models\SM\Department;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\SM\OfficeHierarchy;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\SPMS\EmployeeEvaluation;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Suiterus\Adg\Models\OrgStructure\OrganizationStructureOvertime;
use Suiterus\Adg\Models\OrgStructure\OrganizationStructurePcr;

class Office extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name',
        'description',
        'head_employee_id',
        'status',
        'created_by',
        'updated_by',
    ];

    protected $with = [
        'childOffices',
        'department',
        'headEmployee'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.offices';
        parent::__construct($attributes);
    }

    public function pcrs()
    {
        return $this->morphMany(OrganizationStructurePcr::class, 'pcrable');
    }

    public function overtime()
    {
        return $this->morphMany(OrganizationStructureOvertime::class, 'otable');
    }

    public function childOffices()
    {
        return $this->hasMany(OfficeHierarchy::class, 'parent_office_id', 'id')->with(['childOffice']);
    }

    public function headEmployee()
    {
        return $this->belongsTo(User::class, 'head_employee_id', 'id')->without([
            'employeeMetaInfo',
            'roles',
            'permissions',
            'storage',
            'supervisor',
            'user_supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        ]);
    }

    public function divisions(){
        return $this->hasMany(Division::class, 'office_id', 'id');
    }

    public function units()
    {
        return $this->hasMany(Unit::class, 'office_id', 'id');
    }

    public function department()
    {
        return $this->hasMany(Department::class, 'office_id', 'id');
    }

    public function evaluation()
    {
        return $this->hasMany(EmployeeEvaluation::class, 'office_id', 'id');
    }
}
