<?php

namespace Suiterus\Adg\Models\SM;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\SM\Branch;


class Holiday extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'holidays';

    protected $fillable = [
        'title',
        'description',
        'holiday_type_id',
        'branch_id',
        'time_effectivity',
        'purpose',
        'date',
        'status',
        'created_by',
        'updated_by'
    ];

    public function type(){
        return $this->hasOne(HolidayType::class, 'holiday_type_id', 'id');
    }

    public function branch(){
        return $this->hasOne(Branch::class, 'branch_id', 'id');
    }
}
