<?php

namespace Suiterus\Adg\Models\SM;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;


class EmployeeType extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $fillable = [
        'title',
        'abbreviation',
        'description',
        'type',
        'status',
        'created_by',
        'updated_by'
    ];

    public function typesHistory(){
        return $this->hasMany('Suiterus\Adg\Models\EMI\EmployeeTypeHistory');
    }

    public function positionHasSalary(){
        return $this->hasMany(Position_has_salary::class, 'employee_type', 'id');
    }

}
