<?php

namespace Suiterus\Adg\Models\SM;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EmployeeContribution extends Model
{
    use HasFactory;

    protected $connection = 'adg_db';

    protected $table = 'employee_contributions';

    protected $fillable = [
        'user_id',
        'contribution_id',
        'amount',
        'ecip'
    ];

    protected $with = [
        'user'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.employee_contributions';
        $this->connection = env('ADG_DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function contributionType()
    {
        return $this->belongsTo(Contribution::class, 'contribution_id', 'id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id')->without([
            'currentRole',
            'roles',
            'permissions',
            'storage',
            'employeeMetaInfo',
            'supervisor',
            'user_supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        ]);
    }
}
