<?php

namespace Suiterus\Adg\Models\SM;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\SM\Division;
use App\Models\User;

class Division_history extends Model
{
    use HasFactory, SoftDeletes;
    
    protected $connection = 'adg_db';
    
    protected $fillable = [
        
        'user_id',
        'division_id',
        'division_status',
        'created_by',
        'updated_by',
        
    ];

    protected $appends = [
        'formatted_created_at'
    ];

    protected $with = [
        'user',
        'division'
    ];

    public function user(){
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function division(){
        return $this->belongsTo(Division::class, 'division_id', 'id');
    }

    public function getFormattedCreatedAtAttribute(){
        return date("F d, Y", strtotime($this->created_at));
    }
}
