<?php

namespace Suiterus\Adg\Models\SM;

use App\Models\User;
use Suiterus\Adg\Models\SM\Office;
use Suiterus\Adg\Models\SM\Section;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\Mentorship\Mentorship;
use Suiterus\Adg\Models\SPMS\EmployeeEvaluation;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Suiterus\Adg\Models\OrgStructure\OrganizationStructurePcr;
use Suiterus\Adg\Models\OrgStructure\OrganizationStructureOvertime;

class Division extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name',
        'description',
        'office_id',
        'department_id',
        'head_employee_id',
        'status',
        'created_by',
        'updated_by',
    ];

    protected $with = [
        'sections'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.divisions';
        parent::__construct($attributes);
    }

    public function pcrs()
    {
        return $this->morphMany(OrganizationStructurePcr::class, 'pcrable');
    }

    public function overtime()
    {
        return $this->morphMany(OrganizationStructureOvertime::class, 'otable');
    }

    public function headEmployee()
    {
        return $this->belongsTo(User::class, 'head_employee_id', 'id')->without(
            'currentRole',
            'roles',
            'permissions',
            'storage',
            'employeeMetaInfo',
            'supervisor',
            'user_supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        );
    }

    public function office(){
        return $this->belongsTo(Office::class, 'office_id', 'id');
    }

    public function department()
    {
        return $this->belongsTo(Department::class, 'department_id', 'id');
    }

    public function sections()
    {
        return $this->hasMany(Section::class, 'division_id', 'id');
    }

    public function units()
    {
        return $this->hasMany(Unit::class, 'division_id', 'id');
    }

    public function mentorship()
    {
        return $this->morphOne(Mentorship::class, 'entity');
    }

    public function evaluation()
    {
        return $this->hasMany(EmployeeEvaluation::class, 'division_id', 'id');
    }

    public function getOrganizationTypeAttribute()
    {
        return 'division';
    }
}
