<?php

namespace Suiterus\Adg\Models\SM;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\User;

class DesignationHistory extends Model
{
    use HasFactory;

    protected $connection = 'adg_db';

    protected $table = 'designation_histories';

    protected $fillable = [
        'user_id',
        'corp_id',
        'branch_id',
        'division_id',
        'department_id',
        'date_of_designation',
        'status',
        'employment_status',
        'created_by',
        'updated_by',
    ];

    protected $appends = [
        'formatted_date_of_designation'
    ];

    public function user(){
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function corporation(){
        return $this->belongsTo(Corporation::class, 'corp_id', 'id');
    }

    public function branch(){
        return $this->belongsTo(Branch::class, 'branch_id', 'id');
    }

    public function division(){
        return $this->belongsTo(Division::class, 'division_id', 'id');
    }

    public function department(){
        return $this->belongsTo(Department::class, 'department_id', 'id');
    }

    public function getFormattedDateOfDesignationAttribute(){
        return date("F d, Y", strtotime($this->date_of_designation));
    }
}
