<?php

namespace Suiterus\Adg\Models\SM;

use App\Models\User;
use Suiterus\Adg\Models\SM\Office;
use Suiterus\Adg\Models\SM\Division;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\Reports\Reports;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\EMI\EmployeeMetaInfo;
use Suiterus\Adg\Models\Mentorship\Mentorship;
use Suiterus\Adg\Models\SPMS\EmployeeEvaluation;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Suiterus\Adg\Models\OrgStructure\OrganizationStructurePcr;
use Suiterus\Adg\Models\OrgStructure\OrganizationStructureOvertime;

class Department extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name',
        'description',
        'head_employee_id',
        'office_id',
        'status',
        'created_by',
        'updated_by',
    ];

    protected $with = [
        'divisions'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.departments';
        parent::__construct($attributes);
    }

    public function pcrs()
    {
        return $this->morphMany(OrganizationStructurePcr::class, 'pcrable');
    }

    public function overtime()
    {
        return $this->morphMany(OrganizationStructureOvertime::class, 'otable');
    }

    public function headEmployee()
    {
        return $this->belongsTo(User::class, 'head_employee_id', 'id')->without(
            'currentRole',
            'roles',
            'permissions',
            'storage',
            'employeeMetaInfo',
            'supervisor',
            'user_supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        );
    }

    public function units()
    {
        return $this->hasMany(Unit::class, 'department_id', 'id');
    }

    public function divisions()
    {
        return $this->hasMany(Division::class, 'department_id', 'id');
    }

    public function office()
    {
        return $this->belongsTo(Office::class, 'office_id', 'id');
    }

    public function mentorship()
    {
        return $this->morphOne(Mentorship::class, 'entity');
    }

    public function reportable()
    {
        return $this->morphOne(Reports::class, 'entity');
    }

    public function evaluation()
    {
        return $this->hasMany(EmployeeEvaluation::class, 'department_id', 'id');
    }
}
