<?php

namespace Suiterus\Adg\Models\SM;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\SM\Corporation;
use App\Models\User;

class Corporation_history extends Model
{
    use HasFactory, SoftDeletes;
    
    protected $connection = 'adg_db';
    
    protected $fillable = [
        'user_id',
        'corp_id',
        'corporation_status',
        'created_by',
        'updated_by',
    ];

    protected $appends = [
        'formatted_created_at'
    ];

    protected $with = [
        'user',
        'corporation'
    ];

    public function user(){
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function corporation(){
        return $this->belongsTo(Corporation::class, 'corp_id', 'id');
    }

    public function getFormattedCreatedAtAttribute(){
        return date("F d, Y", strtotime($this->created_at));
    }
}
