<?php

namespace Suiterus\Adg\Models\SM;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Corporation extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';
    
    protected $table = 'corporations';

    protected $fillable = [
        'name',
        'office_code',
        'employer_id',
        'description',
        'status',
    ];

    public function __construct(array $attributes = []) {
        $this->table = env('ADG_DB_DATABASE') . '.corporations';
        parent::__construct($attributes);
    }

    public function employeeMetaInfo(){
        return $this->hasMany(EmployeeMetaInfo::class, 'corp_id', 'id');
    }
}
