<?php

namespace Suiterus\Adg\Models\SM;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Contribution extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'contributions';

    protected $fillable = [
        'name',
        'type',
        'employee_share',
        'company_share',
        'savings_rate',
        'effectivity_date',
        'ecip',
        'status',
        'description',
        'created_by'
    ];

    protected $with = [
        'employeeContribution'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.contributions';
        $this->connection = env('ADG_DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function employeeContribution()
    {
        return $this->hasMany(EmployeeContribution::class, 'contribution_id', 'id');
    }
}
