<?php

namespace Suiterus\Adg\Models\SM;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\SM\Branch;
use App\Models\User;

class Branch_history extends Model
{
    use HasFactory, SoftDeletes;
    
    protected $connection = 'adg_db';
    
    protected $fillable = [
        
        'user_id',
        'branch_id',
        'branch_status',
        'created_by',
        'updated_by'
        
    ];

    protected $appends = [
        'formatted_created_at'
    ];

    protected $with = [
        'user',
        'branch'
    ];

    public function user(){
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function branch(){
        return $this->belongsTo(Branch::class, 'branch_id', 'id');
    }

    public function getFormattedCreatedAtAttribute(){
        return date("F d, Y", strtotime($this->created_at));
    }
}
