<?php

namespace Suiterus\Adg\Models\Reports;

use App\Models\User;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Suiterus\Adg\Models\SM\Department;
use Suiterus\Hrjp\Models\ItemCode;
use Suiterus\Hrjp\Models\Position;
use Suiterus\Hrjp\Models\Position_has_salary;

class TimeSinceLastPromotionReports extends Model
{
    use HasFactory;

    protected $fillable = [
        'department_id',
        'total_employees',
        'promoted_employees',
        'average_month',
        'start_date',
        'end_date',
        'created_by',
        'updated_by',
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.time_since_last_promotion_reports';
        $this->connection = env('ADG_DB_CONNECTION');
        parent::__construct($attributes);
    }

    protected $with = [
        'department',
    ];

    public function department() {
        return $this->belongsTo(Department::class, 'department_id', 'id');
    }

}
