<?php

namespace Suiterus\Adg\Models\Reports;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SalnReports extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'saln_reports';

    protected $fillable = [
        'user_id',
        'net_worth',
        'justification',
        'attachment',
        'status',
        'created_by',
        'updated_by',
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.saln_reports';
        $this->connection = env('ADG_DB_CONNECTION');
        parent::__construct($attributes);
    }

    protected $appends = [
        'formatted_created_at'
    ];

    public function getFormattedCreatedAtAttribute(){
        return date("F d, Y", strtotime($this->created_at));
    }

    public function user() 
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }
}
