<?php

namespace Suiterus\Adg\Models\Reports;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Reports extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'reports';

    protected $fillable = [
        'entity_type',
        'entity_id',
        'report_type',
        'report_creator',
        'status',
        'remarks',
        'snapshot',
        'start_date',
        'end_date',
        'created_by',
        'updated_by',
    ];

    protected $with = [
        'entity'
    ];

    public function creator() {
        return $this->belongsTo(User::class, 'report_creator', 'id');
    }

    public function entity() {
        return $this->morphTo('entity');
    }
}
