<?php

namespace Suiterus\Adg\Models\Reports;

use App\Models\User;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Suiterus\Hrjp\Models\ItemCode;
use Suiterus\Hrjp\Models\Position;
use Suiterus\Hrjp\Models\Position_has_salary;

class CostPerHireReports extends Model
{
    use HasFactory;

    protected $fillable = [
        'position_id',
        'no_job_post',
        'direct_expenses_total',
        'indirect_expenses_total',
        'cost_per_hire_total',
        'created_by',
        'updated_by',
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.cost_per_hire_reports';
        $this->connection = env('ADG_DB_CONNECTION');
        parent::__construct($attributes);
    }

    protected $with = [
        'position',
    ];

    public function position() {
        return $this->belongsTo(Position::class, 'position_id', 'id');
    }

}
