<?php

namespace Suiterus\Adg\Models\Reports;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class AbsenceReports extends Model
{
    use HasFactory;

    protected $fillable = [
        'start_date',
        'end_date',
        'total_employees',
        'working_days',
        'average_working_days',
        'days_lost',
        'absent_rate',
        'file_path',
        'remarks',
        'status',
        'created_by',
        'updated_by',
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.absence_rate_reports';
        $this->connection = env('ADG_DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function absence_rate_data() 
    {
        return $this->hasMany(AbsenceReportData::class, 'absence_rate_report_id', 'id');
    }
}
