<?php

namespace Suiterus\Adg\Models\Reports;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class AbsenceReportData extends Model
{
    use HasFactory;

    protected $fillable = [
        'absence_rate_report_id',
        'date',
        'total_employees',
        'working_days',
        'days_lost',
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.absence_rate_report_data';
        $this->connection = env('ADG_DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function absence_rate_report()
    {
        return $this->belongsTo(AbsenceReports::class, 'absence_rate_report_id');
    }
}
