<?php

namespace Suiterus\Adg\Models\Promotion;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PromotionReschedule extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'promotion_reschedule';

    protected $fillable = [
        'application_process_id',
        'schedule',
        'reason',
        'status',
        'created_by',
        'updated_by',
        'deleted_at'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.promotion_reschedule';
        $this->connection = env('ADG_DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function promotionProcess()
    {
        return $this->belongsTo(PromotionProcess::class, 'application_process_id', 'id');
    }
}
