<?php

namespace Suiterus\Adg\Models\Promotion;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PromotionProcess extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'promotion_process';

    protected $fillable = [
        'application_id',
        'schedule',
        'interviewer',
        'link',
        'description',
        'step',
        'status',
        'created_by',
        'updated_by',
        'deleted_at'
    ];

    protected $with = [
        'reschedule'
    ];
    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.promotion_process';
        $this->connection = env('ADG_DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function promotionApplication()
    {
        return $this->belongsTo(PromotionApplication::class, 'application_id', 'id');
    }

    public function reschedule()
    {
        return $this->hasOne(PromotionReschedule::class, 'application_process_id', 'id');
    }
}
