<?php

namespace Suiterus\Adg\Models\Promotion;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PromotionApplicationFiles extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'promotion_application_files';

    protected $fillable = [
        'application_id',
        'file_path',
        'created_by',
        'deleted_at'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.promotion_application_files';
        $this->connection = env('ADG_DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function promotionApplication()
    {
        return $this->belongsTo(PromotionApplication::class, 'application_id', 'id');
    }
}
