<?php

namespace Suiterus\Adg\Models\Promotion;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\Supplemental\SupplementalCompletionUser;
use Suiterus\Adg\Models\Supplemental\SupplementalDetailUser;
use Suiterus\Adg\Models\Supplemental\SupplementalRequirementUser;
use Suiterus\Hrjp\Models\Position;
use Suiterus\Hrjp\Models\Position_has_salary;

class PromotionApplication extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'promotion_application';

    protected $fillable = [
        'user_id',
        'status',
        'position_id',
        'phs_id',
        'created_by',
        'updated_by',
        'deleted_at'
    ];

    protected $with = [
        'files',
        'completions',
        'details',
        'requirements'
    ];

    protected $appends = [
        'formatted_date_of_application'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.promotion_application';
        $this->connection = env('ADG_DB_CONNECTION');
        parent::__construct($attributes);
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function position()
    {
        return $this->belongsTo(Position::class, 'position_id', 'id');
    }

    public function phs()
    {
        return $this->belongsTo(Position_has_salary::class, 'phs_id', 'id');
    }

    public function process()
    {
        return $this->hasOne(PromotionProcess::class, 'application_id', 'id');
    }

    public function files()
    {
        return $this->hasMany(PromotionApplicationFiles::class, 'application_id', 'id');
    }

    public function completions(){
        return $this->hasMany(SupplementalCompletionUser::class, 'application_id', 'id');
    }

    public function details(){
        return $this->hasMany(SupplementalDetailUser::class, 'application_id', 'id');
    }
    public function requirements(){
        return $this->hasMany(SupplementalRequirementUser::class, 'application_id', 'id');
    } 

    public function getFormattedDateOfApplicationAttribute(){
        return date("F d, Y", strtotime($this->created_at));
    }
}
