<?php

namespace Suiterus\Adg\Models\Payroll;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Ramsey\Uuid\Type\Decimal;

class WithholdingTax extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'withholding_taxes';

    protected $fillable = [
        'payroll_employee_id',
        'annual_basic_pay',
        'gsis_sss',
        'pagibig',
        'philhealth',
        'union_dues',
        'taxable_basic_salary',
        'mid_year_bonus',
        'year_end_bonus',
        'pei',
        'taxable_13th_month',
        'taxable_compensation',
        'tax_exemption',
        'annual_tax_due',
        'tax_option'
    ];

    protected $appends = [
        'monthly_a',
        'monthly_b',
    ];

    public function __construct(array $attributes = []) {
        $this->table = env('ADG_DB_DATABASE') . '.withholding_taxes';
        parent::__construct($attributes);
    }

    public function payroll_employee() {
        return $this->belongsTo('Suiterus\Adg\Models\Payroll\PayrollEmployee', 'payroll_employee_id', 'id');       
    }

    public function getAnnualBasicPayAttribute($value) {
        return number_format($value, 2);
    }
    public function getGsisSssAttribute($value) {
        return number_format($value, 2);
    }
    public function getPagibigAttribute($value) {
        return number_format($value, 2);
    }
    public function getPhilhealthAttribute($value) {
        return number_format($value, 2);
    }
    public function getUnionDuesAttribute($value) {
        return number_format($value, 2);
    }
    public function getTaxableBasicSalaryAttribute($value) {
        return number_format($value, 2);
    }
    public function getMidYearBonusAttribute($value) {
        return number_format($value, 2);
    }
    public function getYearEndBonusAttribute($value) {
        return number_format($value, 2);
    }
    public function getTaxable13thMonthAttribute($value) {
        return number_format($value, 2);
    }
    public function getTaxableCompensationAttribute($value) {
        return number_format($value, 2);
    }
    public function getAnnualTaxDueAttribute($value) {
        return number_format($value, 2);
    }
    public function getPeiAttribute($value) {
        return number_format($value, 2);
    }

    public function getMonthlyAAttribute() {
        $annual_tax_due = $this->getRawOriginal('annual_tax_due');
        return $annual_tax_due > 0 ? number_format(($annual_tax_due / 12), 2) : 0;
    }
    public function getMonthlyBAttribute() {
        $annual_tax_due = $this->getRawOriginal('annual_tax_due');
        return $annual_tax_due > 0 ? number_format(($annual_tax_due / 14), 2) : 0;
    }


}
