<?php

namespace Suiterus\Adg\Models\Payroll;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TimekeepingDeduction extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'timekeeping_deductions';

    protected $fillable = [
        'payroll_employee_id',
        'date',
        'minutes',
        'type',
        'points',
        'basic_pay_deduction',
        'pera_deduction',
        'leave_balance_remaining',
        'leave_balance_deduction',
        'leave_balance_result'
    ];

    protected $appends = [
        'formatted_minutes',
        'formatted_type',
        'formatted_date'
    ];

    public function employee_payroll() {
        return $this->belongsTo('Suiterus\Adg\Models\Payroll\PayrollEmployee', 'payroll_employee_id', 'id');
    } 

    public function getFormattedMinutesAttribute() {
        $hours = floor($this->minutes / 60);
        $minutes = $this->minutes % 60;
        $time = $minutes . ' minutes';
        if($hours > 0) {
            $time = $hours . ' hours, ' . $minutes . ' minutes';
        }
        return $time;
    }

    public function getFormattedTypeAttribute() {
        $type = 'Absent';
        if($this->type == 2) { $type = 'Late'; }
        else if($this->type == 3) { $type = 'Undertime'; }
        else if($this->type == 4) { $type = 'Half Day'; }
        return $type;
    }

    public function getFormattedDateAttribute() {
        return date("F d, Y", strtotime($this->date));
    }
}
