<?php

namespace Suiterus\Adg\Models\Payroll;

use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\Payroll\SpecialPay;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class SpecialPayFrequency extends Model
{
    use HasFactory;

    protected $connection = 'adg_db';

    protected $table = 'special_pay_frequencies';

    protected $fillable = [
        'title',
        'status'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.special_pay_frequencies';
        parent::__construct($attributes);
    }

    public function specialPay() {
        return $this->hasMany(SpecialPay::class,'special_pay_frequency_id', 'id');
    }
}
