<?php

namespace Suiterus\Adg\Models\Payroll;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\Salary\EmployeeSpecialPay;
use Suiterus\Adg\Models\Payroll\SpecialPayFrequency;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class SpecialPay extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'special_pays';

    protected $fillable = [
        'title',
        'description',
        'special_pay_frequency_id',
        'amount',
        'amount_per_frequency',
        'start_date',
        'end_date',
        'period',
        'created_by',
        'updated_by',
        'deleted_by',
        'status'
    ];

    protected $with = [
        'employees',
        'specialPayFrequency'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.special_pays';
        parent::__construct($attributes);
    }

    public function employees() {
        return $this->hasMany(EmployeeSpecialPay::class, 'special_pay_id', 'id');
    }

    // Users
    public function users() {
        return $this->belongsToMany(User::class, 'employee_special_pays', 'special_pay_id', 'user_id');
    }

    public function specialPayFrequency() {
        return $this->belongsTo(SpecialPayFrequency::class,'special_pay_frequency_id', 'id');
    }
}
