<?php

namespace Suiterus\Adg\Models\Payroll;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\SM\Holiday;

class PayrollHolidayBreakdown extends Model
{
    use HasFactory;


    protected $fillable = [
        'earning_deduction_id',
        'holiday_id',
        'date',
        'holiday_type',
        'holiday_title',
        'holiday_pay',
    ];

    protected $with = [
        'holiday'
    ];


    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.payroll_holiday_breakdowns';
        parent::__construct($attributes);
    }

    public function holiday(){
        return $this->belongsTo(Holiday::class, 'holiday_id', 'id');
    }
}
