<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Suiterus\Adg\Models\LeaveManagement\LeaveCreditHistory;
use Suiterus\Adg\Models\Payroll\PayrollEmployee;

class PayrollEmployeeLeaveHistory extends Model
{
    use HasFactory;

    protected $connection = 'adg_db';

    protected $table = 'payroll_employee_leave_histories';

    protected $fillable = [
        'payroll_employee_id',
        'leave_credit_history_id',
    ];

    public function payrollEmployee(){
        return $this->belongsTo(PayrollEmployee::class, 'payroll_employee_id', 'id');
    }

    public function leaveCreditHistory(){
        return $this->belongsTo(LeaveCreditHistory::class, 'leave_credit_history_id', 'id');
    }
}
