<?php

namespace Suiterus\Adg\Models\Payroll;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PayrollEarningDeduction extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'payroll_earning_deductions';

    protected $fillable = [
        'payroll_employee_id',
        'name',
        'amount',
        'type',
        'category',
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.payroll_earning_deductions';
        parent::__construct($attributes);
    }

    public function payroll_employee()
    {
        return $this->belongsTo('Suiterus\Adg\Models\Payroll\PayrollEmployee', 'payroll_employee_id', 'id');
    }

    public function allowance_breakdown(){
        return $this->hasMany(PayrollAllowanceBreakdown::class, 'earning_deduction_id', 'id');
    }

    public function pay_breakdown(){
        return $this->hasMany(PayrollPayBreakdown::class, 'earning_deduction_id', 'id');
    }

    public function holiday_breakdown(){
        return $this->hasMany(PayrollHolidayBreakdown::class, 'earning_deduction_id', 'id');
    }

    public function refund_breakdown(){
        return $this->hasMany(LeaveRefund::class, 'earning_deduction_id', 'id');
    }
}
