<?php

namespace Suiterus\Adg\Models\Payroll;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PayrollAllowanceBreakdown extends Model
{
    use HasFactory;

    protected $fillable = [
        'earning_deduction_id',
        'lwop_type',
        'date',
        'minutes',
        'gross_amount',
        'deducted_amount',
        'resulting_amount',
        'remarks'
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.payroll_allowance_breakdowns';
        parent::__construct($attributes);
    }

    public function earningDeduction()
    {
        return $this->belongsTo(PayrollEarningDeduction::class, 'earning_deduction_id', 'id');
    }
}
