<?php

namespace Suiterus\Adg\Models\Payroll;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Payroll extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'payrolls';

    protected $fillable = [
        'payroll_officer',
        'type',
        'entity_type',
        'entity',
        'period_start',
        'period_end',
        'file',
        'status',
        'remarks',
        'payroll_employee_generated_count',
        'payroll_employee_total_count',
        'metadata',
        'completion_date',
        'created_by',
        'updated_by',
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.payrolls';
        parent::__construct($attributes);
    }

    protected $appends = [
        'formatted_date',
    ];

    protected $with = [
        'user'
    ];

    protected $casts = [
        'metadata' => 'json'
    ];

    public function user()
    {
        return $this->belongsTo('App\Models\User', 'payroll_officer', 'id');
    }

    public function payroll_employee()
    {
        return $this->hasMany('Suiterus\Adg\Models\Payroll\PayrollEmployee', 'payroll_id', 'id');
    }

    public function employee_earnings_deductions()
    {
        return $this->hasManyThrough('Suiterus\Adg\Models\Payroll\PayrollEarningDeduction', 'Suiterus\Adg\Models\Payroll\PayrollEarningDeduction', 'payroll_employee_id', 'payroll_id', 'id', 'id');
    }

    public function getFormattedDateAttribute()
    {
        $date = $this->completion_date;
        if ($date != null) {
            $date = date('F d, Y', strtotime($this->completion_date));
        }
        return $date;
    }
}
