<?php

namespace Suiterus\Adg\Models\Payroll;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MandatoryContributionTemplate extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'mandatory_contribution_templates';

    protected $fillable = [
        'title',
        'description',
        'status',
        'created_by',
        'updated_by',
    ];

    public function values() {
        return $this->hasMany('Suiterus\Adg\Models\Payroll\MandatoryContribution', 'template_id', 'id');
    }
}
